'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Button_Abbruch_Click()
    DoCmd.Close
End Sub

Private Sub Button_OK_Click()
On Error GoTo Err_Button_OK_Click


    BerichteUeberschrift = ""
    BerichteFilter = ""
    BerichteJahreswahl = ""

    BerichteUeberschrift = "Aktualisierungen fr " & Jahresauswahl
    BerichteFilter = "[Jahr]=" & Jahresauswahl
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    'Jahresauswahl schliessen
    ReJahr = Me.Jahresauswahl.Value
    DoCmd.Close acForm, "Aktualisierungen_Jahreswahl", acSaveNo
    
    'Gre des Reportfensters und Berichts-Zoom optimieren
    'erst Fensterbreite und -hhe ermitteln, und nach dem ffnen des Reports anpassen
    AnwendungGroesseErmitteln
    
    'Formular anzeigen
    DoCmd.OpenReport TextEingabe, acPreview
'    'Formular Jahr filtern
'    Reports.Item(TextEingabe).Filter = "[Jahr]=" & ReJahr
'    Reports.Item(TextEingabe).Controls.Item("Ueberschrift").Caption = "Aktualisierungen fr " & ReJahr

    'Berichtsfenster nun auf Anwendungsgre zoomen
    DoCmd.MoveSize 0, 0, FormularBreite, FormularHoehe
    'Berichtsvorschau auf ganzes Blatt zoomen
    DoCmd.RunCommand acCmdFitToWindow


Exit_Button_OK_Click:
    Exit Sub

Err_Button_OK_Click:
    MsgBox err.Description
    Resume Exit_Button_OK_Click
    
End Sub

Private Sub Form_Load()
    'Jahresauswahl auf das letzte Rechnungsjahr einstellen
    Me.Jahresauswahl.DefaultValue = Me.Jahr.Value
End Sub
